/* global check_load */
(function () {
  "use strict";

  check_load[0] = false;
  check_load[1] = false;

  const
    // URLS
    url_json_fall_game = "../assets/json/fall_game.json",

    // Selectors
    s10 = document.getElementById("modal_game"),
    s11 = document.getElementById("title_modal_game"),
    s12 = document.getElementById("message_modal_game"),
    s13 = document.getElementById("close_modal_game"),
    s14 = document.getElementById("start_btn"),
    s19 = document.getElementById("subtitle_modal_game"),

    // Class
    c1 = "active",
    c5 = "hide",

    NSCatchBall = (function () {
      function loadJSON(url) {
        return fetch(url).then(response => response.json());
      }

      return {
        fall_game: () => {
          s13.addEventListener("click", () => {
            s10.classList.remove(c1);
            s14.classList.remove(c5);
          });
        }, // fall_game

        load_templates_api: async () => {
          await Promise.all([
            loadJSON(url_json_fall_game)
          ])
            .then(([data_fall]) => {
              NSCatchBall.data_fall = data_fall;
              check_load[1] = true;
            })
            .catch(err => console.error(err))
            ;
        } // load_templates_api
      };
    }())
    ;

  window.addEventListener("load", async function () {
    check_load[0] = true;
    await NSCatchBall.load_templates_api();
    NSCatchBall.fall_game();
  });

  window.addEventListener("fallgame:win", () => {
    s10.classList.add(c1);

    for (const item of NSCatchBall.data_fall) {
      if (item.id === "win") {
        s11.textContent = item.title;
        s19.textContent = item.subtitle;
        s12.textContent = item.message;
      }
    }
  });

  window.addEventListener("fallgame:lose", () => {
    s10.classList.add(c1);

    for (const item of NSCatchBall.data_fall) {
      if (item.id === "lose") {
        s11.textContent = item.title;
        s19.textContent = item.subtitle;
        s12.textContent = item.message;
      }
    }
  });
}());