/* global check_load  */

(function () {
    "use strict";

    check_load[0] = false;

    const
        // URLS
        url_template = "../templates/menu.html",
        url_main_json = "../assets/json/main.json",

        // Selectors
        s0 = document.body,
        s1 = document.getElementById("main_header"),

        c1 = "btn_white",
        c2 = "btn_transparent",

        // Namespaces
        NSMenu = (function () {
            function loadHTML(url) {
                return fetch(url).then(response => response.text());
            }

            function loadJSON(url) {
                return fetch(url).then(response => response.json());
            }

            return {
                data_main: {},
                init: () => {
                    const
                        template = document.getElementById("template_menu"),
                        menu = template.content.cloneNode(true),
                        linkt = menu.querySelector(".btn_trionda"),
                        linkj = menu.querySelector(".btn_jersey"),
                        calltoaction = menu.querySelector(".calltoaction")

                    ;

                    if (template && s1) {
                        switch (window.location.pathname) {
                            case "/":
                            case "/index.html":
                                linkt.classList.add(c1);
                                linkj.classList.add(c2);
                                
                            break;
                            case "/jersey.html":
                                linkj.classList.add(c1);
                                linkt.classList.add(c2);
                                
                            break;
                            default:
                                linkt.classList.add(c1);
                                linkj.classList.add(c2);
                                
                            break;
                        }

                        calltoaction.setAttribute("href", NSMenu.data_main.call);
                        calltoaction.setAttribute("target", NSMenu.data_main.target_call);

                        s1.appendChild(menu);
                    }
                }, // init

                load_templates_api: async () => {
                    await Promise.all([
                        loadHTML(url_template),
                        loadJSON(url_main_json)
                    ])
                        .then(([
                            templates,
                            data_main
                        ]) => {
                            s0.insertAdjacentHTML("afterend", templates);
                            NSMenu.data_main = data_main;
                            check_load[0] = true;
                        })
                        .catch(err => console.error(err))
                    ;
                } // load_templates_api
            };
        }())
    ;

    window.addEventListener("load", async function () {
        await NSMenu.load_templates_api();
        NSMenu.init();
    });
}());
