/* global check_load  */

(function () {
    "use strict";

    check_load[0] = false;

    const
        // ULRs
        url_template = "../templates/templates.html",
        url_json_showcase_jersey = "../assets/json/showcase_jersey.json",

        // Selectors
        s0 = document.body,
        s2 = document.getElementById("showcase_jersey"),

        // Class
        c1 = "active",
        c2 = "open",
        c5 = "hide",
        c6_j = "fed_",

        // Variables
        current_page = "jersey",
        current_module = "showcase",

        NSJersey = (function () {
            function loadHTML(url) {
                return fetch(url).then(response => response.text());
            }

            function loadJSON(url) {
                return fetch(url).then(response => response.json());
            }

            function change_body_federation(index) {
                s0.classList.forEach(cls => {
                    if (cls.startsWith(c6_j)) s0.classList.remove(cls);
                });

                if (index > 0) {
                    s0.classList.add(c6_j + index);
                }
            }

            function change_showcase_jersey(index) {
                const data = NSJersey.data_showcase_jersey[index];
                if (!data) return;

                const showcase = s2.querySelector(".wrapper_showcase_jersey");
                if (!showcase) return;

                const
                    bg_text_country = showcase.querySelectorAll(".country_showcase_jersey"),
                    img_jersey = showcase.querySelector(".img_visor_showcase_jersey"),
                    instructions = showcase.querySelector(".content_instructions"),
                    block1_title = showcase.querySelector(".block_left_top .block_title"),
                    block1_paragraph1 = showcase.querySelector(".block_left_top .block_paragraph"),
                    block1_image1 = showcase.querySelector(".block_left_top .block_image"),
                    block1_paragraph2 = showcase.querySelector(".block_right_bottom .block_paragraph"),
                    block1_image2 = showcase.querySelector(".block_right_bottom .block_image"),
                    block2_title = showcase.querySelector(".block_2 .block_title"),
                    block2_paragraph = showcase.querySelector(".block_2 .block_paragraph"),
                    block2_image = showcase.querySelector(".block_2 .block_image"),
                    block3_title = showcase.querySelector(".block_3 .block_title"),
                    block3_paragraph = showcase.querySelector(".block_3 .block_paragraph"),
                    block3_image = showcase.querySelector(".block_3 .block_image"),
                    buy_title = showcase.querySelector(".content_buy_now .title_showcase_jersey"),
                    buy_subtitle = showcase.querySelector(".content_buy_now .subtitle_showcase_jersey"),
                    buy_cta = showcase.querySelector(".content_buy_now .content_link"),
                    buy_url = showcase.querySelector(".content_buy_now .btn_buy")
                ;

                // Actualiza el identificador visual del país
                showcase.className = `wrapper_showcase_jersey ${data.country_class}`;

                // Actualiza textos e imágenes
                bg_text_country.forEach(country => {
                    country.textContent = data.country;
                });
                img_jersey.src = data.img_jersey;
                img_jersey.alt = data.country;

                instructions.textContent = data.instructions;

                block1_title.textContent = data.block1_title;
                block1_paragraph1.textContent = data.block1_paragraph1;
                block1_image1.src = data.block1_image1;
                block1_image1.alt = data.block1_image1_alt;
                block1_paragraph2.textContent = data.block1_paragraph2;
                block1_image2.src = data.block1_image2;
                block1_image2.alt = data.block1_image2_alt;

                block2_title.textContent = data.block2_title;
                block2_paragraph.textContent = data.block2_paragraph;
                block2_image.src = data.block2_image;
                block2_image.alt = data.block2_image_alt;

                block3_title.textContent = data.block3_title;
                block3_paragraph.textContent = data.block3_paragraph;
                block3_image.src = data.block3_image;
                block3_image.alt = data.block3_image_alt;

                buy_title.textContent = data.buy_title;
                buy_subtitle.textContent = data.buy_subtitle;
                buy_cta.textContent = data.buy_cta;
                buy_url.href = data.buy_url || "#";
                buy_url.target = data.buy_target || "_top";

                change_body_federation(index);
            } // change_showcase_jersey

            let current_index_showcase = 0; // índice actual de país/jersey

            function setup_showcase_navigation() {
                const
                    b1 = document.querySelector(".btn_fed_prev"),
                    b2 = document.querySelector(".btn_fed_next")
                ;

                if (!b1 || !b2) return;

                const showcaseData = Array.isArray(NSJersey.data_showcase_jersey)
                    ? NSJersey.data_showcase_jersey
                    : [];

                if (showcaseData.length === 1) {
                    b1.classList.add(c5);
                    b2.classList.add(c5);
                    return;
                }

                b1.classList.remove(c5);
                b2.classList.remove(c5);

                b1.addEventListener("click", function () {
                    if (NSJersey.data_showcase_jersey.length === 0) return;

                    current_index_showcase--;
                    if (current_index_showcase < 0) {
                        current_index_showcase = NSJersey.data_showcase_jersey.length - 1;
                    }

                    change_showcase_jersey(current_index_showcase);
                });

                b2.addEventListener("click", function () {
                    if (NSJersey.data_showcase_jersey.length === 0) return;

                    current_index_showcase++;
                    if (current_index_showcase >= NSJersey.data_showcase_jersey.length) {
                        current_index_showcase = 0;
                    }

                    change_showcase_jersey(current_index_showcase);
                });
            }

            return {
                data_showcase_jersey: [],

                initial_tooltip: () => {
                    const tooltips = [
                            document.getElementById("ct1"),
                            document.getElementById("ct2"),
                            document.getElementById("ct3")
                        ].filter(Boolean),
                        main_wrapper = s2.querySelector(".wrapper_showcase_jersey")
                        ;

                    for (const item of tooltips) {
                        let cent = true;

                        const
                            btn_open = item.querySelector(".open_tooltip"),
                            btn_close = item.querySelector(".close_tooltip"),
                            tooltips = item.querySelectorAll(".content_tooltip")
                        ;

                        btn_open.addEventListener("click", function () {
                            main_wrapper.scrollIntoView({
                                behavior: "smooth",
                                block: "start"
                            });

                            main_wrapper.classList.add(c1);
                            main_wrapper.parentElement.classList.add(this.parentElement.id);
                            this.parentElement.classList.add(c1);

                            if (cent) {
                                tooltips.forEach(tooltip => {
                                    if (tooltip.classList.contains(c2)) {
                                        main_wrapper.classList.remove(c1);
                                        tooltip.classList.remove(c2);
                                        this.parentElement.classList.remove(c1);
                                        main_wrapper.parentElement.classList.remove(this.parentElement.id);
                                    } else {
                                        tooltip.classList.add(c2);
                                    }
                                });

                                this.classList.toggle(c1);

                                setTimeout(() => { cent = true; }, 1000);
                                cent = false;
                            }
                        });

                        btn_close.addEventListener("click", function () {
                            main_wrapper.classList.remove(c1);
                            main_wrapper.parentElement.classList.remove(this.parentElement.parentElement.id);
                            this.parentElement.parentElement.classList.remove(c1);
                            if (cent) {
                                tooltips.forEach(tooltip => {
                                    tooltip.classList.remove(c2);
                                });
                                btn_open.classList.remove(c1);

                                setTimeout(() => { cent = true; }, 1000);
                                cent = false;
                            }
                        });
                    }
                },

                load_items_showcase_jersey: () => {
                    const data = NSJersey.data_showcase_jersey[0];
                    if (!data) return;

                    const
                        template = document.getElementById("template_shocase_jersey"),
                        showcase_jersey = template.content.cloneNode(true),
                        main_wrapper = showcase_jersey.querySelector(".wrapper_showcase_jersey");

                    main_wrapper.classList.add(data.country_class);
                    s2.appendChild(showcase_jersey);

                    change_showcase_jersey(0);
                }, // load_items_showcase_jersey

                showcase_jersey: () => {
                    NSJersey.load_items_showcase_jersey();
                    setup_showcase_navigation();
                }, // showcase_jersey

                load_templates_api: async () => {
                    await Promise.all([
                        loadHTML(url_template),
                        loadJSON(url_json_showcase_jersey),
                    ])
                        .then(([
                            templates,
                            data_showcase_jersey,
                        ]) => {
                            const container = document.createElement("div");
                            container.innerHTML = templates;

                            const filteredTemplates = Array
                                .from(container.querySelectorAll("template"))
                                .filter(templateEl => {
                                    const pageTarget = templateEl.dataset.page || "both";

                                    const moduleTarget = templateEl.dataset.module || "";

                                    return pageTarget === "both" || pageTarget === current_page && moduleTarget === current_module;
                                })
                                .map(templateEl => templateEl.outerHTML)
                                .join("")
                            ;

                            if (filteredTemplates) {
                                s0.insertAdjacentHTML("afterend", filteredTemplates);
                            }
                            NSJersey.data_showcase_jersey = data_showcase_jersey;

                            check_load[1] = true;
                        })
                        .catch(err => console.error(err))
                    ;
                } // load_templates_api
            };
        }())
    ;

    window.addEventListener("load", async function () {
        await NSJersey.load_templates_api();
        NSJersey.showcase_jersey();
        NSJersey.initial_tooltip();
        check_load[0] = true;
    });
}());

(function preventDummyLinksDelegated() {
    document.addEventListener("click", function (e) {
        const a = e.target.closest("a[href]");
        if (!a) return;

        const href = (a.getAttribute("href") || "").trim();
        if (href === "" || href === "#") {
        e.preventDefault();
        e.stopPropagation();
        }
    }, true);
})();
