/* global check_load, SimpleSlider, Swiper  */

(function () {
    "use strict";

    check_load[0] = false;

    const
        // ULRs
        url_template = "../templates/templates.html",
        url_main_json = "../assets/json/main.json",
        url_json_showcase_jersey = "../assets/json/showcase_jersey.json",
        url_json_pro_jersey = "../assets/json/pro_jersey.json",

        // Selectors
        s0 = document.body,
        s1 = document.getElementById("container_slider_jersey"),
        s2 = document.getElementById("showcase_jersey"),
        s3 = document.getElementById("container_cards"),
        s5 = document.getElementById("main_header"),
        s4_j = document.getElementById("container_header"),
        s5_j = document.getElementById("bg_main_jersey"),
        s6_j = document.getElementById("bg_top"),
        s7_j = document.getElementById("btn_start"),
        s8_j = document.getElementById("title_cover"),
        s9_j = document.getElementById("description_cover"),
        s10_j = document.getElementById("cover_passion"),
        s11_j = document.getElementById("title_main_slider"),
        s12_j = document.getElementById("game_passion"),
        s13_j = document.getElementById("time_game"),
        s14_j = document.getElementById("match"),
        s15_j = document.getElementById("reload_game"),
        s12_l = document.getElementById("container_marquee_footer"),
        s16_j = document.getElementById("win_game"),
        s17_j = document.getElementById("lost_game"),
        s18_j = document.getElementById("btn_reload_game_1"),
        s19_j = document.getElementById("btn_reload_game_2"),
        s_instruction = document.querySelector(".instruction"),
        s_title_find_passion = document.querySelector(".title_find_passion"),
        s_container_marquee_footer = document.getElementById("container_marquee_footer"),

        // Class
        c1 = "active",
        c2 = "open",
        c3 = "inactive",
        c4 = "hide",
        c1_j = "marquee_1",
        c2_j = "marquee_2",
        c3_j = "country",
        c4_j = "wc",
        c5_j = "marquee",
        c6_j = "fed_",

        // Variables
        current_page = "jersey",
        nm1 = 5,

        NSJersey = (function () {
            function loadHTML(url) {
                return fetch(url).then(response => response.text());
            }

            function loadJSON(url) {
                return fetch(url).then(response => response.json());
            }

            function update_header_height() {
                document.documentElement.style.setProperty("--header-height", `${s4_j.offsetHeight}px`);
            }

            function change_main_slider() {
                if (NSJersey.now_federation === null) return;
                s11_j.textContent = NSJersey.now_federation.t1;
                if (NSJersey.now_federation.country === "Costa Rica") {
                    s11_j.classList.add("white");
                    if (s_instruction) {
                        s_instruction.classList.add("white");
                    }
                    if (s_title_find_passion) {
                        s_title_find_passion.classList.add("white");
                    }
                    if (s_container_marquee_footer) {
                        s_container_marquee_footer.classList.add("white");
                    }
                } else {
                    s11_j.classList.remove("white");
                    if (s_instruction) {
                        s_instruction.classList.remove("white");
                    }
                    if (s_title_find_passion) {
                        s_title_find_passion.classList.remove("white");
                    }
                    if (s_container_marquee_footer) {
                        s_container_marquee_footer.classList.remove("white");
                    }
                }
            }

            function change_top() {
                if (NSJersey.now_federation === null) return;

                const
                    bgs = s6_j.querySelectorAll("[class^='bg_main_']")
                ;

                for (const bg of bgs) bg.classList.remove(c1, c3);

                for (const bg of bgs) {
                    if (bg.classList.contains(NSJersey.now_federation.image_top)) bg.classList.add(c1);
                    if (bg.classList.contains(NSJersey.prev_federation.image_top)) bg.classList.add(c3);
                }
            } // change_top

            function change_body_federation(index) {
                if (NSJersey.now_federation === null) return;

                for (let i = 0; i < NSJersey.data_main.federations.length; i++) {
                    s0.classList.remove(c6_j + i);
                }

                if (index !== 0) s0.classList.add(c6_j + index);
            } // change_body_federation

            function change_marquee() {
                if (NSJersey.marquee_items.length === 0) return;

                const fallback = (Array.isArray(NSJersey.data_main.federations) && NSJersey.data_main.federations.length > 0)
                    ? NSJersey.data_main.federations[0]
                    : NSJersey.data_main,
                    source = NSJersey.now_federation || fallback
                ;

                if (!source) return;

                const
                    country = source.country || NSJersey.data_main.country || "",
                    wc = source.wc || NSJersey.data_main.wc || ""
                ;

                for (const record of NSJersey.marquee_items) {
                    if (!record || !record.items) continue;

                    const
                        is_country = record.type === "country",
                        target_class = is_country ? c3_j : c4_j,
                        text = is_country ? country : wc
                    ;

                    for (const item of record.items) {
                        if (!item) continue;
                        item.classList.remove(c3_j, c4_j);
                        item.classList.add(target_class);
                        item.textContent = text;
                    }
                }
            } // change_marquee

            function change_pro_jersey() {
                if (!s3) return;

                const items = NSJersey.sort_pro_jersey_items();

                s3.innerHTML = "";
                if (items.length > 0) {
                    NSJersey.load_items_slider_jersey(items);
                }

                if (NSJersey.pro_swiper) {
                    NSJersey.pro_swiper.updateSlides();
                    NSJersey.pro_swiper.updateProgress();
                    NSJersey.pro_swiper.updateSlidesClasses();
                    NSJersey.pro_swiper.slideTo(0, 0);
                    NSJersey.pro_swiper.update();
                }

                // Update the pro jersey title based on current federation
                const titleElement = document.querySelector(".title_pro_jersey");
                if (titleElement && NSJersey.now_federation && NSJersey.now_federation.pro_jersey_title) {
                    titleElement.textContent = NSJersey.now_federation.pro_jersey_title;
                }
            } // change_pro_jersey

            function change_showcase_jersey(index) {
                const data = NSJersey.data_showcase_jersey[index];
                if (!data) return;

                const showcase = s2.querySelector(".wrapper_showcase_jersey");
                if (!showcase) return;

                const
                    bg_text_country = showcase.querySelectorAll(".country_showcase_jersey"),
                    img_jersey = showcase.querySelector(".img_visor_showcase_jersey"),
                    instructions = showcase.querySelector(".content_instructions"),
                    block1_title = showcase.querySelector(".block_left_top .block_title"),
                    block1_paragraph1 = showcase.querySelector(".block_left_top .block_paragraph"),
                    block1_image1 = showcase.querySelector(".block_left_top .block_image"),
                    block1_paragraph2 = showcase.querySelector(".block_right_bottom .block_paragraph"),
                    block1_image2 = showcase.querySelector(".block_right_bottom .block_image"),
                    block2_title = showcase.querySelector(".block_2 .block_title"),
                    block2_paragraph = showcase.querySelector(".block_2 .block_paragraph"),
                    block2_image = showcase.querySelector(".block_2 .block_image"),
                    block3_title = showcase.querySelector(".block_3 .block_title"),
                    block3_paragraph = showcase.querySelector(".block_3 .block_paragraph"),
                    block3_image = showcase.querySelector(".block_3 .block_image"),
                    buy_title = showcase.querySelector(".content_buy_now .title_showcase_jersey"),
                    buy_subtitle = showcase.querySelector(".content_buy_now .subtitle_showcase_jersey"),
                    buy_cta = showcase.querySelector(".content_buy_now .content_link"),
                    buy_url = showcase.querySelector(".content_buy_now .btn_buy")
                ;

                // Actualiza el identificador visual del país
                showcase.className = `wrapper_showcase_jersey ${data.country_class}`;

                // Actualiza textos e imágenes
                bg_text_country.forEach(country => {
                    country.textContent = data.country;
                });
                img_jersey.src = data.img_jersey;
                img_jersey.alt = data.country;

                instructions.textContent = data.instructions;

                block1_title.textContent = data.block1_title;
                block1_paragraph1.textContent = data.block1_paragraph1;
                block1_image1.src = data.block1_image1;
                block1_image1.alt = data.block1_image1_alt;
                block1_paragraph2.textContent = data.block1_paragraph2;
                block1_image2.src = data.block1_image2;
                block1_image2.alt = data.block1_image2_alt;

                block2_title.textContent = data.block2_title;
                block2_paragraph.textContent = data.block2_paragraph;
                block2_image.src = data.block2_image;
                block2_image.alt = data.block2_image_alt;

                block3_title.textContent = data.block3_title;
                block3_paragraph.textContent = data.block3_paragraph;
                block3_image.src = data.block3_image;
                block3_image.alt = data.block3_image_alt;

                buy_title.textContent = data.buy_title;
                buy_subtitle.textContent = data.buy_subtitle;
                buy_cta.textContent = data.buy_cta;
                buy_url.href = data.buy_url || "#";
                buy_url.target = data.buy_target || "_top";
            } // change_showcase_jersey

            function change_footer(index) {
                const template = document.getElementById("template_marquee_footer_jersey");

                if (!s12_l || !template) return;

                const federations = Array.isArray(NSJersey.data_main.federations)
                    ? NSJersey.data_main.federations
                    : [];

                const federation = federations[index];
                if (!federation) return;

                s12_l.innerHTML = "";

                const marquee = document.createElement("div");
                marquee.classList.add("marquee", "marquee_2");

                const createMarqueeContent = () => {
                    const content = template.content.cloneNode(true);
                    content.querySelectorAll(".marquee_item.wc").forEach(item => {
                        item.textContent = federation.wc;
                    });
                    content.querySelectorAll(".marquee_item.t1").forEach(item => {
                        item.textContent = federation.t1;
                    });
                    return content;
                };
                marquee.appendChild(createMarqueeContent());
                marquee.appendChild(createMarqueeContent());

                s12_l.appendChild(marquee);
            } // change_footer

            return {
                data_showcase_jersey: [],
                data_pro_jersey: [],
                data_main: {},
                now_federation: null,
                prev_federation: null,
                pro_swiper: null,
                marquee_items: [],

                initial: () => {
                    if (!s6_j) return;

                    const federations = Array.isArray(NSJersey.data_main.federations)
                        ? NSJersey.data_main.federations
                        : [];

                    if (federations.length > 1) {
                        federations.forEach((federation, index) => {
                            const fed = document.createElement("div");
                            fed.classList.add(federation.image_top);

                            if (index === 0) {
                                NSJersey.now_federation = federation;
                                fed.classList.add(c1);
                            }

                            s6_j.appendChild(fed);
                        });
                    } else if (federations[0].image_top) {
                        const fallback = document.createElement("div");
                        fallback.classList.add(federations[0].image_top, c1);
                        s6_j.appendChild(fallback);

                        NSJersey.now_federation = federations[0];
                        NSJersey.prev_federation = null;
                    }
                    change_marquee();
                    // Load initial slider images based on federation order
                    const sliderItems = s1.querySelectorAll(".slider_item");
                    federations.forEach((federation, index) => {
                        if (sliderItems[index] && federation.slider_image) {
                            const img = sliderItems[index].querySelector(".img_jersey");
                            if (img) {
                                img.src = federation.slider_image;
                                img.alt = federation.country + " Jersey";
                            }
                        }
                    });
                },

                initial_tooltip: () => {
                    const tooltips = [
                            document.getElementById("ct1"),
                            document.getElementById("ct2"),
                            document.getElementById("ct3")
                        ].filter(Boolean),
                        main_wrapper = s2.querySelector(".wrapper_showcase_jersey")
                        ;

                    for (const item of tooltips) {
                        let cent = true;

                        const
                            btn_open = item.querySelector(".open_tooltip"),
                            btn_close = item.querySelector(".close_tooltip"),
                            tooltips = item.querySelectorAll(".content_tooltip")
                        ;

                        btn_open.addEventListener("click", function () {
                            main_wrapper.scrollIntoView({
                                behavior: "smooth",
                                block: "start"
                            });

                            main_wrapper.classList.add(c1);
                            main_wrapper.parentElement.classList.add(this.parentElement.id);
                            this.parentElement.classList.add(c1);

                            if (cent) {
                                tooltips.forEach(tooltip => {
                                    if (tooltip.classList.contains(c2)) {
                                        main_wrapper.classList.remove(c1);
                                        tooltip.classList.remove(c2);
                                        this.parentElement.classList.remove(c1);
                                        main_wrapper.parentElement.classList.remove(this.parentElement.id);
                                    } else {
                                        tooltip.classList.add(c2);
                                    }
                                });

                                this.classList.toggle(c1);

                                setTimeout(() => { cent = true; }, 1000);
                                cent = false;
                            }
                        });

                        btn_close.addEventListener("click", function () {
                            main_wrapper.classList.remove(c1);
                            main_wrapper.parentElement.classList.remove(this.parentElement.parentElement.id);
                            this.parentElement.parentElement.classList.remove(c1);
                            if (cent) {
                                tooltips.forEach(tooltip => {
                                    tooltip.classList.remove(c2);
                                });
                                btn_open.classList.remove(c1);

                                setTimeout(() => { cent = true; }, 1000);
                                cent = false;
                            }
                        });
                    }
                },

                load_items_showcase_jersey: () => {
                    const data = NSJersey.data_showcase_jersey[0];
                    if (!data) return;

                    const
                        template = document.getElementById("template_shocase_jersey"),
                        showcase_jersey = template.content.cloneNode(true),
                        main_wrapper = showcase_jersey.querySelector(".wrapper_showcase_jersey");

                    main_wrapper.classList.add(data.country_class);
                    s2.appendChild(showcase_jersey);

                    change_showcase_jersey(0);
                }, // load_items_showcase_jersey

                showcase_jersey: () => {
                    NSJersey.load_items_showcase_jersey();
                }, // showcase_jersey

                scroll: () => {
                    if (window.scrollY > 50) s5.classList.add(c1);
                    else s5.classList.remove(c1);
                }, // scroll

                load_bg_main_jersey: () => {
                    const template = document.getElementById("template_marquee_jersey_1");

                    if (!template) return null;
                    if (!s5_j) return null;

                    s5_j.textContent = "";
                    NSJersey.marquee_items = [];

                    for (let i = 0; i < nm1; i++) {
                        const
                            marquee = document.createElement("div"),
                            useCountry = (i % 2) === 0,
                            textClass = useCountry ? c3_j : c4_j,
                            record = { items: [], type: useCountry ? "country" : "wc" }
                        ;

                        marquee.classList.add(c5_j, (i % 2) ? c2_j : c1_j);

                        for (let j = 0; j < 2; j++) {
                            const
                                marquee_content = template.content.cloneNode(true),
                                marquee_item = marquee_content.querySelectorAll(".marquee_item")
                            ;

                            for (const item of marquee_item) {
                                item.classList.remove(c3_j, c4_j);
                                item.classList.add(textClass);
                                record.items.push(item);
                            }

                            marquee.appendChild(marquee_content);
                        }

                        s5_j.appendChild(marquee);
                        NSJersey.marquee_items.push(record);
                    }

                    change_marquee();
                }, // load_bg_main_jersey

                change_brand_strip_language: function () {
                    if (!NSJersey.now_federation) return;

                    const brandStrip = document.getElementById("brand_strip");
                    if (!brandStrip) return;

                    const container = brandStrip.querySelector(".container_brand_strip");
                    if (!container) return;

                    const isEnglish = NSJersey.now_federation.english === true;

                    // Get all fifa_world_cup_2 and copa_del_mundo elements
                    const fifaElements = container.querySelectorAll(".fifa_world_cup_2");
                    const copaElements = container.querySelectorAll(".copa_del_mundo");

                    if (isEnglish) {
                        // Change fifa_world_cup_2 to copa_del_mundo
                        fifaElements.forEach(element => {
                            element.classList.remove("fifa_world_cup_2");
                            element.classList.add("copa_del_mundo");
                        });
                    } else {
                        // Change copa_del_mundo to fifa_world_cup_2
                        copaElements.forEach(element => {
                            element.classList.remove("copa_del_mundo");
                            element.classList.add("fifa_world_cup_2");
                        });
                    }

                    // Get all official_match_ball and camiseta_oficial elements
                    const officialElements = container.querySelectorAll(".official_match_ball");
                    const camisetaElements = container.querySelectorAll(".camiseta_oficial");

                    if (isEnglish) {
                        // Change official_match_ball to camiseta_oficial
                        officialElements.forEach(element => {
                            element.classList.remove("official_match_ball");
                            element.classList.add("camiseta_oficial");
                        });
                    } else {
                        // Change camiseta_oficial to official_match_ball
                        camisetaElements.forEach(element => {
                            element.classList.remove("camiseta_oficial");
                            element.classList.add("official_match_ball");
                        });
                    }
                }, // change_brand_strip_language

                change_find_passion_title: function () {
                    if (!NSJersey.now_federation) return;

                    const titleElement = document.querySelector(".title_find_passion");
                    if (titleElement && NSJersey.now_federation.find_passion_title) {
                        titleElement.textContent = NSJersey.now_federation.find_passion_title;
                    }
                }, // change_find_passion_title

                change_instruction_text: function () {
                    if (!NSJersey.now_federation) return;

                    const instructionElement = document.querySelector(".instruction");
                    if (instructionElement && NSJersey.now_federation.instruction_text) {
                        instructionElement.textContent = NSJersey.now_federation.instruction_text;
                    }
                }, // change_instruction_text

                change_info: (index) => {
                    const nextFederation = NSJersey.data_main.federations[index];
                    if (!nextFederation || nextFederation === NSJersey.now_federation) return;

                    NSJersey.prev_federation = NSJersey.now_federation;
                    NSJersey.now_federation = nextFederation;

                    console.log(`Federación que organiza: ${NSJersey.now_federation.country}`);

                    change_top();
                    change_body_federation(index);
                    change_showcase_jersey(index);
                    change_main_slider();
                    change_marquee();
                    change_pro_jersey();
                    change_footer(index);
                    NSJersey.change_brand_strip_language();
                    NSJersey.change_find_passion_title();
                    NSJersey.change_instruction_text();
                }, // change_info

                main_slider: () => {
                    if (typeof SimpleSlider !== "undefined") {
                        const
                            main_slider = new SimpleSlider(s1, {
                                classControlNext: "next_slider_jersey",
                                classControlPrev: "prev_slider_jersey",
                                dirClass: "asc",
                                blockClickControl: 500,
                                linkIndicator: true,
                            })
                        ;
                        main_slider.init();
                        if (NSJersey.data_main.federations.length !== 0) {
                            main_slider.addEventListener("slideIndex", (e) => {
                                NSJersey.change_info(e.detail.index);
                            });
                        }
                    }

                    if (s4_j) {
                        update_header_height();
                        window.addEventListener("resize", update_header_height);
                    }
                }, // main_slider

                load_items_slider_jersey: (items = NSJersey.data_pro_jersey) => {
                    if (!s3 || !Array.isArray(items) || items.length === 0) {
                        return;
                    }

                    const template = document.getElementById("template_swiper_slide_jersey");
                    if (!template) return;

                    for (const data of items) {
                        const
                            pro_jersey = template.content.cloneNode(true),
                            card = pro_jersey.querySelector(".card"),
                            img = pro_jersey.querySelector(".img_product"),
                            img_back = pro_jersey.querySelector(".img_technical"),
                            name = pro_jersey.querySelector(".name_product"),
                            title_back_1 = pro_jersey.querySelector(".title_back_1"),
                            title_back_2 = pro_jersey.querySelector(".title_back_2"),
                            price = pro_jersey.querySelector(".price_product"),
                            link = pro_jersey.querySelector(".btn_buy"),
                            btn_flip_card = pro_jersey.querySelector(".btn_flip_card"),
                            btn_close_flip_card = pro_jersey.querySelector(".btn_close_flip_card")
                        ;

                        img.src = data.img;
                        img.alt = data.name;

                        name.textContent = data.name;
                        price.textContent = data.price;

                        title_back_1.textContent = data.title_back_1;
                        title_back_2.textContent = data.title_back_2;
                        img_back.src = data.img_back;
                        img_back.alt = data.title_back_1 + " " + data.title_back_2;

                        link.href = data.url || "#";
                        link.target = data.target || "_top";

                        const information = pro_jersey.querySelector(".information");

                        if (NSJersey.data_main.card_flip_enabled !== false) {
                            btn_flip_card.style.cursor = "pointer";
                            btn_flip_card.addEventListener("click", function () {
                                card.classList.add(c1);
                            });
                            information.style.display = "flex";
                        } else {
                            btn_flip_card.style.cursor = "default";
                            information.style.display = "none";
                        }

                        btn_close_flip_card.addEventListener("click", function () {
                            card.classList.remove(c1);
                        });
                        if (card) {
                            card.dataset.country = (data.country || "").toString().trim().toLowerCase();
                        }
s3.appendChild(pro_jersey);
                    }
                }, // load_items_slider_jersey

                sort_pro_jersey_items: () => {
                    const items = Array.isArray(NSJersey.data_pro_jersey)
                        ? NSJersey.data_pro_jersey.slice()
                        : [];

                    if (!NSJersey.now_federation || items.length === 0) return items;

                    const normalize = value => (value || "").toString().trim().toLowerCase();
                    const targetCountry = normalize(NSJersey.now_federation.country);
                    if (!targetCountry) return items;

                    const matching = items.filter(item => normalize(item.country) === targetCountry);
                    const remaining = items.filter(item => normalize(item.country) !== targetCountry);

                    return matching.concat(remaining);
                }, // sort_pro_jersey_items

                pro_jersey: () => {
                    const initialItems = NSJersey.sort_pro_jersey_items(NSJersey.now_federation);
                    if (initialItems.length > 0) {
                        NSJersey.load_items_slider_jersey(initialItems);
                    }

                    // Update the pro jersey title based on current federation on initial load
                    const titleElement = document.querySelector(".title_pro_jersey");
                    if (titleElement && NSJersey.now_federation && NSJersey.now_federation.pro_jersey_title) {
                        titleElement.textContent = NSJersey.now_federation.pro_jersey_title;
                    }

                    // Update the instruction text based on current federation on initial load
                    NSJersey.change_instruction_text();

                    NSJersey.pro_swiper = new Swiper(".swiper", {
                        slidesPerView: 1,
                        spaceBetween: 0,
                        freeMode: true,
                        breakpoints: {
                            320: {
                                slidesPerView: 1,
                                spaceBetween: 15,
                            },
                            480: {
                                slidesPerView: 1.5,
                                spaceBetween: 30,
                            },
                            768: {
                                slidesPerView: 2,
                                spaceBetween: 25,
                            },
                            980: {
                                slidesPerView: 3,
                                spaceBetween: 20,
                            },
                            1280: {
                                slidesPerView: 4,
                                spaceBetween: 20,
                            },
                            1440: {
                                slidesPerView: 5,
                                spaceBetween: 15,
                            }
                        },
                        scrollbar: {
                            el: ".swiper-scrollbar",
                            hide: false,
                            draggable: true,
                            snapOnRelease: false,
                        }
                    });

                    NSJersey.pro_swiper.update();
                }, // pro_jersey

                find_passion: () => {
                    if (typeof window.PassionGame === "undefined") return;

                    // Update the find passion title based on current federation on initial load
                    NSJersey.change_find_passion_title();

                    const modals = [s16_j, s17_j];

                    const hideGameModals = () => {
                        for (const modal of modals) {
                            if (!modal) continue;
                            modal.classList.remove(c1);
                            modal.classList.add(c3);
                        }
                    };

                    const showGameModal = (modal) => {
                        hideGameModals();
                        if (!modal) return;
                        modal.classList.remove(c3);
                        modal.classList.add(c1);
                    };

                    const handleModalRestart = (event) => {
                        if (event) event.preventDefault();
                        hideGameModals();
                        if (window.PassionGame && typeof window.PassionGame.restart_game === "function") {
                            window.PassionGame.restart_game();
                        }
                    };

                    window.PassionGame.init({
                        start_button: s7_j,
                        cover_elements: [s7_j, s8_j, s9_j, s10_j],
                        card_container: s12_j,
                        timer_display: s13_j,
                        matches_display: s14_j,
                        reload_button: s15_j,
                        hidden_class: c4,
                        inactive_class: c3,
                        active_class: c1
                    });

                    hideGameModals();

                    if (s12_j) {
                        s12_j.addEventListener("passionGame:win", () => {
                            showGameModal(s16_j);
                        });

                        s12_j.addEventListener("passionGame:lose", () => {
                            showGameModal(s17_j);
                        });
                    }

                    if (s18_j) {
                        s18_j.addEventListener("click", handleModalRestart);
                    }

                    if (s19_j) {
                        s19_j.addEventListener("click", handleModalRestart);
                    }

                    if (s15_j) {
                        s15_j.addEventListener("click", () => {
                            hideGameModals();
                        });
                    }
                }, // find_passion

                footer_marquee: () => {
                    change_footer(0);
                }, // footer_marquee

                load_templates_api: async () => {
                    await Promise.all([
                        loadHTML(url_template),
                        loadJSON(url_json_showcase_jersey),
                        loadJSON(url_json_pro_jersey),
                        loadJSON(url_main_json)
                    ])
                        .then(([
                            templates,
                            data_showcase_jersey,
                            data_pro_jersey,
                            data_main
                        ]) => {
                            const container = document.createElement("div");
                            container.innerHTML = templates;

                            const filteredTemplates = Array
                                .from(container.querySelectorAll("template"))
                                .filter(templateEl => {
                                    const pageTarget = templateEl.dataset.page || "both";
                                    return pageTarget === "both" || pageTarget === current_page;
                                })
                                .map(templateEl => templateEl.outerHTML)
                                .join("")
                            ;

                            if (filteredTemplates) {
                                s0.insertAdjacentHTML("afterend", filteredTemplates);
                            }
                            NSJersey.data_showcase_jersey = data_showcase_jersey;
                            NSJersey.data_pro_jersey = data_pro_jersey;
                            NSJersey.data_main = data_main;

                            check_load[1] = true;
                        })
                        .catch(err => console.error(err))
                    ;
                } // load_templates_api
            };
        }())
    ;

    window.addEventListener("load", async function () {
        await NSJersey.load_templates_api();
        NSJersey.load_bg_main_jersey();
        NSJersey.initial();
        NSJersey.change_brand_strip_language();
        NSJersey.showcase_jersey();
        NSJersey.main_slider();
        NSJersey.pro_jersey();
        NSJersey.initial_tooltip();
        NSJersey.find_passion();
        NSJersey.footer_marquee();
        check_load[0] = true;
    });

    window.addEventListener("scroll", () => { NSJersey.scroll(); });

    window.addEventListener("pagehide", () => {
        window.scroll({ top: 0, left: 0, behavior: "instant" });
    });
}());

(function preventDummyLinksDelegated() {
  document.addEventListener("click", function (e) {
    const a = e.target.closest("a[href]");
    if (!a) return;

    const href = (a.getAttribute("href") || "").trim();
    if (href === "" || href === "#") {
      e.preventDefault();
      e.stopPropagation();
    }
  }, true);
})();
