/* global gsap, ScrollTrigger, SimpleSlider, check_load, CheckView2 */

(function () {
    "use strict";

    check_load[0] = false;
    check_load[1] = false;
    check_load[2] = false;

    let
        did_desktop = false,
        did_mobile  = false
    ;

    const
        // URLS
        url_template = "../templates/templates.html",
        url_json_historic = "../assets/json/historic_ball.json",
        url_json_fall_game = "../assets/json/fall_game.json",
        url_json_showcase = "../assets/json/showcase.json",

        // Selectors
        s0 = document.body,
        s1 = document.getElementById("main_header"),
        s2 = document.getElementById("rotate_instruction"),
        s3 = document.getElementById("slider_showcase"),
        s7 = document.getElementById("container_slider_historic"),
        s8 = document.getElementById("container_balls"),
        s9 = document.getElementById("slider_historic"),
        s10 = document.getElementById("modal_game"),
        s11 = document.getElementById("title_modal_game"),
        s12 = document.getElementById("message_modal_game"),
        s13 = document.getElementById("close_modal_game"),
        s14 = document.getElementById("start_btn"),
        s15 = document.getElementById("bg_hero_ball"),
        s16 = document.getElementById("img_visor_showcase"),
        s17 = document.getElementById("container_ball"),
        s18 = document.getElementById("bg_visor_showcase"),
        s19 = document.getElementById("subtitle_modal_game"),
        s20 = document.getElementById("btn_calltoaction_2"),
        s21 = document.getElementById("content_slider_showcase"),

        // tooltips
        s4 = document.getElementById("container_tooltip_1"),
        s5 = document.getElementById("container_tooltip_2"),
        s6 = document.getElementById("container_tooltip_3"),

        // buttons nav sections
        go_hero = document.getElementById("btn_hero_ball"),
        go_showcase = document.getElementById("btn_showcase"),
        go_historic = document.getElementById("btn_historic"),
        go_catch = document.getElementById("btn_catch"),

        // sections
        se_hero = document.getElementById("hero_ball"),
        se_showcase = document.getElementById("showcase"),
        se_historic = document.getElementById("historic_balls"),
        se_catch = document.getElementById("catch_the_ball"),

        go_navs = [
            [go_hero, se_hero],
            [go_showcase, se_showcase],
            [go_historic, se_historic],
            [go_catch, se_catch]
        ],

        // Class
        c1 = "active",
        c2 = "hidden",
        c3 = "open",
        c4 = "close",
        c5 = "hide",
        c6 = "next_1",
        c7 = "next_2",
        c8 = "next_3",
        c9 = "prev_1",
        c10 = "mobile",

        tooltips = [ s4, s5, s6 ],

        currentPage = "trionda",
        matchQuery = window.matchMedia("(min-width: 769px)"),

        NSHome = (function () {
            function loadHTML(url) {
                return fetch(url).then(response => response.text());
            }

            function loadJSON(url) {
                return fetch(url).then(response => response.json());
            }

            return {
                data_historic: [],
                data_fall: [],
                data_showcase: [],

                scroll: () => {
                    if (window.scrollY > 50) s1.classList.add(c1);
                    else s1.classList.remove(c1);
                }, // scroll

                initial_tooltip: () => {
                    for (const item of tooltips) {
                        let cent = true;

                        const
                            btn_open = item.querySelector(".open_tooltip"),
                            btn_close = item.querySelector(".close_tooltip"),
                            tooltip = item.querySelector(".tooltip")
                        ;

                        btn_open.addEventListener("click", function () {
                            this.parentElement.classList.add(c1);

                            if (cent) {
                                if (tooltip.classList.contains(c3)) {
                                    tooltip.classList.remove(c3);
                                    tooltip.classList.add(c4);
                                    this.parentElement.classList.remove(c1);
                                } else {
                                    tooltip.classList.add(c3);
                                    tooltip.classList.remove(c4);
                                }

                                this.classList.toggle(c1);

                                setTimeout(() => { cent = true; }, 1000);
                                cent = false;
                            }
                        });

                        btn_close.addEventListener("click", function () {
                            this.parentElement.parentElement.classList.remove(c1);
                            if (cent) {
                                tooltip.classList.remove(c3);
                                tooltip.classList.add(c4);
                                btn_open.classList.remove(c1);

                                setTimeout(() => { cent = true; }, 1000);
                                cent = false;
                            }
                        });
                    }
                },

                ball_position: (progress, pos1, pos2) => {
                    const
                        ball = document.getElementById("main_ball"),
                        ballBounding = ball.getBoundingClientRect(),

                        dif1 = window.innerWidth >= 640 ? 0 : 12.5,

                        posXi = pos1.left + (pos1.width / 2) - (ballBounding.width / 2) - dif1,
                        posYi = pos1.top + (pos1.height / 2) - (ballBounding.height / 2) - dif1,

                        dif2 = window.innerWidth >= 640 ? 50 : 2,

                        posXf = pos2.left + (pos2.width / 2) - (ballBounding.width / 2) - dif2,
                        posYf = pos2.top + (pos2.height / 2) - (ballBounding.height / 2) - dif2,

                        currentX = (1 - progress) * posXi + progress * posXf,
                        currentY = (1 - progress) * posYi + progress * posYf,
                        scale = (1 - progress) * 1 + progress * 0.8
                    ;

                    ball.style.transform = `translate(${currentX}px, ${currentY}px) scale(${scale})`;
                }, // ball_position

                scroll_ball: () => {
                    const
                        ball = document.getElementById("main_ball"),
                        pos1 = document.getElementById("pos1").getBoundingClientRect(),
                        pos2 = document.getElementById("pos2").getBoundingClientRect(),

                        startY = pos1.top + (pos1.height / 2) + 100,
                        endY = pos2.top + (pos2.height / 2) - (window.innerHeight / 2)
                    ;

                    gsap.registerPlugin(ScrollTrigger);

                    ScrollTrigger.create({
                        trigger: "#container_parallax",
                        start: `${startY} center`,
                        end: `${endY} center`,
                        scrub: 1,
                        ease: "power2.inOut",
                        onUpdate: (self) => { NSHome.ball_position(self.progress, pos1, pos2); /* console.log("onUpdate"); */ },
                        onEnter: () => { NSHome.ball_position(0, pos1, pos2); /* console.log("onEnter"); */ },
                        onLeaveBack: () => { NSHome.ball_position(0, pos1, pos2); /* console.log("onLeaveBack"); */ },
                        onEnterBack: () => {
                            NSHome.ball_position(1, pos1, pos2);
                            for (const item of tooltips) {
                                const
                                    tooltip = item.querySelector(".tooltip")
                                ;
                                item.classList.add(c5);
                                tooltip.classList.remove(c4);
                            }
                            // console.log("onEnterBack");
                        },
                        onLeave: () => {
                            NSHome.ball_position(1, pos1, pos2);

                            let
                                xi = 0,
                                yi = 0,
                                x = 0,
                                y = 0
                            ;

                            const
                                ballClient = ball.getBoundingClientRect(),
                                transform = ball.style.transform,
                                match = transform.match(/translate\(([^,]+)px,\s*([^)]+)px\)/),
                                dif = (((ballClient.width * 5) / 4) - ballClient.width) / 2
                            ;

                            if (match) {
                                xi = parseFloat(match[1]);
                                yi = parseFloat(match[2]);
                            }

                            for (const item of tooltips) {
                                const difb = (window.innerWidth > 980) ? 20 : 15;
                                x = xi + dif - difb + (ballClient.width * (item.dataset.x / 100));
                                y = yi + dif - difb + (ballClient.height * (item.dataset.y / 100));
                                item.style.transform = `translate(${x}px, ${y}px)`;
                                item.classList.remove(c5);
                            }
                            // console.log("onLeave");
                        },

                    });
                }, // scroll_ball

                scroll_ball_mobile: () => {
                    const
                        ball = document.getElementById("main_ball")
                    ;

                    ball.classList.add(c10);
                    s16.classList.add(c10);

                    s15.appendChild(ball);
                    s18.appendChild(s17);

                    for (const item of s17.children) {
                        item.classList.remove(c5);
                    }
                }, // scroll_ball_mobile

                load_showcase: () => {
                    let isFirst = true;


                    for (const data of NSHome.data_showcase) {
                        const
                            template = document.getElementById("template_item_showcase"),
                            showcase = template.content.cloneNode(true),
                            item = showcase.querySelector(".slider_item"),
                            description = showcase.querySelector(".description_slider"),
                            price = showcase.querySelector(".price"),
                            img = showcase.querySelector(".img_slider")
                        ;

                        if (isFirst) {
                            item.classList.add(c1);
                            isFirst = false;
                        }

                        description.textContent = data.name;
                        price.textContent = data.price;
                        img.src = data.img;
                        img.alt = data.name;

                        s21.appendChild(showcase);
                    }
                }, // load_showcase

                slider_showcase: () => {
                    NSHome.load_showcase();

                    const
                        showcase_slider = new SimpleSlider(s3, {
                            classSlider: "slider_showcase",
                            linkIndicator: true
                        })
                    ;

                    showcase_slider.init();
                    showcase_slider.addEventListener("slideIndex", (e) => {
                        const data = NSHome.data_showcase[e.detail.index];

                        s20.href = data.url;
                        s20.target = data.target;
                    });
                }, // slider_showcase

                load_balls: () => {
                    NSHome.data_historic.forEach((data, index) => {
                        const
                            template = document.getElementById("template_item_ball_historic"),
                            ball = template.content.cloneNode(true),
                            item = ball.querySelector(".item_ball"),
                            img = ball.querySelector(".img_ball")
                        ;

                        switch (index) {
                            case 0:
                                item.classList.add(c1);
                                break;
                            case 1:
                                item.classList.add(c6);
                                break;
                            case 2:
                                item.classList.add(c7);
                                break;
                            case 3:
                                item.classList.add(c8);
                                break;
                            case (NSHome.data_historic.length - 1):
                                item.classList.add(c9);
                                break;
                        }

                        item.classList.add(`ball_${index}`);

                        img.src = data.image;
                        img.alt = data.name;

                        s8.appendChild(ball);
                    });
                }, // load_balls

                load_slider_historic: () => {
                    let is_first = true;

                    for (const data of NSHome.data_historic) {
                        const
                            template = document.getElementById("template_item_historic"),
                            historic = template.content.cloneNode(true),
                            item = historic.querySelector(".slider_item"),
                            title = historic.querySelector(".title_historic_balls"),
                            country = historic.querySelector(".country"),
                            description = historic.querySelector(".description_slider"),
                            year = historic.querySelector(".year_historic_balls")
                        ;

                        if (is_first) {
                            item.classList.add(c1);
                            is_first = false;
                        }

                        title.textContent = data.name;
                        country.textContent = data.country;

                        description.textContent = data.description;
                        year.textContent = data.year;

                        s9.appendChild(historic);
                    }
                }, // load_slider_historic

                slider_historic: () => {
                    NSHome.load_slider_historic();
                    NSHome.load_balls();

                    const
                        history_slider = new SimpleSlider(s7, {
                            classControlNext: "next_historic",
                            classControlPrev: "prev_historic",
                            linkIndicator: true
                        })
                    ;

                    history_slider.init();

                    history_slider.addEventListener("slideIndex", (e) => {
                        let
                            next_1 = 0,
                            next_2 = 0,
                            next_3 = 0,
                            prev_1 = 0
                        ;

                        const
                            index = e.detail.index,
                            balls = s8.querySelectorAll(".item_ball")
                        ;

                        function calcIndex(pos, max) {
                            let goPos = 0;

                            switch (pos) {
                                case max: goPos = 0; break;
                                case max + 1: goPos = 1; break;
                                case max + 2: goPos = 2; break;
                            }

                            return goPos;
                        }

                        for (let i = 0; i < balls.length; i++) {
                            if (i === index) balls[i].classList.add(c1);
                            else balls[i].classList.remove(c1);

                            balls[i].classList.remove(c6);
                            balls[i].classList.remove(c7);
                            balls[i].classList.remove(c8);
                            balls[i].classList.remove(c9);
                        }

                        next_1 = (index + 1 < balls.length)
                            ? index + 1 : calcIndex(index + 1, balls.length);
                        next_2 = (index + 2 < balls.length)
                            ? index + 2 : calcIndex(index + 2, balls.length);
                        next_3 = (index + 3 < balls.length)
                            ? index + 3 : calcIndex(index + 3, balls.length);
                        prev_1 = (index - 1 >= 0) ? index - 1 : balls.length - 1;

                        balls[next_1].classList.add(c6);
                        balls[next_2].classList.add(c7);
                        balls[next_3].classList.add(c8);
                        balls[prev_1].classList.add(c9);

                        // console.dir(balls);
                        // console.dir(s8);
                    });
                }, // slider_historic

                fall_game: () => {
                   s13.addEventListener("click", () => {
                       s10.classList.remove(c1);
                       s14.classList.remove(c5);
                   });
                }, // fall_game

                tools: () => {
                    let inRemove = false;
                    const value_inside = 0.3;

                    function removeActive() {
                        if (!inRemove) {
                            inRemove = true;
                            for (const item of go_navs) {
                                item[0].classList.remove(c1);
                            }
                            inRemove = false;
                        }
                    }

                    for (const item of go_navs) {
                        item[0].addEventListener("click", function () {
                            removeActive();

                            item[1].scrollIntoView({
                                behavior: "smooth",
                                block: "start"
                            });
                            this.classList.add(c1);
                        });

                        if (typeof CheckView2 !== "undefined") {
                            new CheckView2(item[1], {
                                threshold: value_inside,
                                callback: (entry) => {
                                    if (entry.isIntersecting) {
                                        removeActive();
                                        item[0].classList.add(c1);
                                    } else {
                                        item[0].classList.remove(c1);
                                    }
                                }
                            }).init();
                        }
                    };
                }, // tools

                evaluate_match_query: () => {
                    if (matchQuery.matches) {
                        if (!did_desktop) {
                            did_desktop = true;
                            did_mobile = false;
                        }
                    } else {
                        if (!did_mobile) {
                            did_desktop = false;
                            did_mobile = true;
                        }
                    }
                }, // evaluate_match_query

                load_templates_api: async () => {
                    await Promise.all([
                        loadHTML(url_template),
                        loadJSON(url_json_historic),
                        loadJSON(url_json_fall_game),
                        loadJSON(url_json_showcase)
                    ])
                        .then(([
                            templates,
                            data_historic,
                            data_fall,
                            data_showcase
                        ]) => {
                            const container = document.createElement("div");
                            container.innerHTML = templates;

                            const filteredTemplates = Array
                                .from(container.querySelectorAll("template"))
                                .filter(templateEl => {
                                    const pageTarget = templateEl.dataset.page || "both";
                                    return pageTarget === "both" || pageTarget === currentPage;
                                })
                                .map(templateEl => templateEl.outerHTML)
                                .join("")
                            ;

                            if (filteredTemplates) {
                                s0.insertAdjacentHTML("afterend", filteredTemplates);
                            }

                            NSHome.data_historic = data_historic;
                            NSHome.data_fall = data_fall;
                            NSHome.data_showcase = data_showcase;
                            check_load[2] = true;
                        })
                        .catch(err => console.error(err))
                    ;
                } // load_templates_api
            };
        }())
    ;

    if ("scrollRestoration" in history) history.scrollRestoration = "manual";

    window.addEventListener("load", async function () {
        await NSHome.load_templates_api();
        NSHome.evaluate_match_query();
        NSHome.initial_tooltip();
        NSHome.slider_showcase();
        NSHome.slider_historic();
        NSHome.fall_game();
        NSHome.tools();

        if (matchQuery.addEventListener) matchQuery.addEventListener("change", NSHome.evaluate_match_query);
        else matchQuery.addListener(NSHome.evaluate_match_query);

        setTimeout(() => {
            const
                pos1 = document.getElementById("pos1").getBoundingClientRect(),
                pos2 = document.getElementById("pos2").getBoundingClientRect()
            ;

            if (did_desktop) NSHome.ball_position(0, pos1, pos2);
            check_load[0] = true;
        }, 800);

        document.addEventListener("loadBall", () => {
            setTimeout(() => {
                if (did_desktop) NSHome.scroll_ball();
                if (did_mobile) NSHome.scroll_ball_mobile();
                check_load[1] = true;
            }, 500);
        });
    });

    window.addEventListener("scroll", () => { NSHome.scroll(); });
    document.addEventListener("stopRotate", () => { s2.classList.add(c2); });

    window.addEventListener("pagehide", () => {
        window.scroll({ top: 0, left: 0, behavior: "instant" });
    });

    window.addEventListener("fallgame:win", () => {
        s10.classList.add(c1);

        for (const item of NSHome.data_fall) {
            if (item.id === "win") {
                s11.textContent = item.title;
                s19.textContent = item.subtitle;
                s12.textContent = item.message;
            }
        }
    });

    window.addEventListener("fallgame:lose", () => {
        s10.classList.add(c1);

        for (const item of NSHome.data_fall) {
            if (item.id === "lose") {
                s11.textContent = item.title;
                s19.textContent = item.subtitle;
                s12.textContent = item.message;
            }
        }
    });

    function is_mobile() {
        return /Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent);
    }

    window.addEventListener("resize", () => {
        if (!is_mobile()) window.location.reload();
    });
}());

(function preventDummyLinksDelegated() {
  document.addEventListener("click", function (e) {
    const a = e.target.closest("a[href]");
    if (!a) return;

    const href = (a.getAttribute("href") || "").trim();
    if (href === "" || href === "#") {
      e.preventDefault();
      e.stopPropagation();
    }
  }, true);
})();
