/* global SimpleSlider, check_load */

(function () {
    "use strict";

    check_load[0] = false;
    check_load[1] = false;

    const
        // URLS
        url_template = "../../templates/templates.html",
        url_json_historic = "../../assets/json/historic_ball.json",

        // Selectors
        s0 = document.body,
        s1 = document.getElementById("container_slider_historic"),
        s2 = document.getElementById("container_balls"),
        s3 = document.getElementById("slider_historic"),

        // Class
        c1 = "active",
        c6 = "next_1",
        c7 = "next_2",
        c8 = "next_3",
        c9 = "prev_1",


        NSHistoric = (function () {
            function loadHTML(url) {
                return fetch(url).then(response => response.text());
            }

            function loadJSON(url) {
                return fetch(url).then(response => response.json());
            }

            return {
                data_historic: [],

                load_balls: () => {
                    NSHistoric.data_historic.forEach((data, index) => {
                        const
                            template = document.getElementById("template_item_ball_historic"),
                            ball = template.content.cloneNode(true),
                            item = ball.querySelector(".item_ball"),
                            img = ball.querySelector(".img_ball")
                        ;

                        switch (index) {
                            case 0:
                                item.classList.add(c1);
                                break;
                            case 1:
                                item.classList.add(c6);
                                break;
                            case 2:
                                item.classList.add(c7);
                                break;
                            case 3:
                                item.classList.add(c8);
                                break;
                            case (NSHistoric.data_historic.length - 1):
                                item.classList.add(c9);
                                break;
                        }

                        item.classList.add(`ball_${index}`);

                        img.src = data.image;
                        img.alt = data.name;

                        s2.appendChild(ball);
                    });
                }, // load_balls

                load_slider_historic: () => {
                    let is_first = true;

                    for (const data of NSHistoric.data_historic) {
                        const
                            template = document.getElementById("template_item_historic"),
                            historic = template.content.cloneNode(true),
                            item = historic.querySelector(".slider_item"),
                            country = historic.querySelector(".country"),
                            description = historic.querySelector(".description_slider"),
                            year = historic.querySelector(".year_historic_balls")
                        ;

                        if (is_first) {
                            item.classList.add(c1);
                            is_first = false;
                        }

                        country.textContent = data.country;
                        country.insertAdjacentText("beforebegin", data.name);

                        description.textContent = data.description;
                        year.textContent = data.year;

                        s3.appendChild(historic);
                    }
                },

                slider_historic: () => {
                    NSHistoric.load_slider_historic();
                    NSHistoric.load_balls();

                    const
                        history_slider = new SimpleSlider(s1, {
                            classControlNext: "next_historic",
                            classControlPrev: "prev_historic",
                            linkIndicator: true
                        })
                    ;

                    history_slider.init();

                    history_slider.addEventListener("slideIndex", (e) => {
                        let
                            next_1 = 0,
                            next_2 = 0,
                            next_3 = 0,
                            prev_1 = 0
                        ;

                        const
                            index = e.detail.index,
                            balls = s2.querySelectorAll(".item_ball")
                        ;

                        function calcIndex(pos, max) {
                            let goPos = 0;

                            switch (pos) {
                                case max: goPos = 0; break;
                                case max + 1: goPos = 1; break;
                                case max + 2: goPos = 2; break;
                            }

                            return goPos;
                        }

                        for (let i = 0; i < balls.length; i++) {
                            if (i === index) balls[i].classList.add(c1);
                            else balls[i].classList.remove(c1);

                            balls[i].classList.remove(c6);
                            balls[i].classList.remove(c7);
                            balls[i].classList.remove(c8);
                            balls[i].classList.remove(c9);
                        }

                        next_1 = (index + 1 < balls.length)
                            ? index + 1 : calcIndex(index + 1, balls.length);
                        next_2 = (index + 2 < balls.length)
                            ? index + 2 : calcIndex(index + 2, balls.length);
                        next_3 = (index + 3 < balls.length)
                            ? index + 3 : calcIndex(index + 3, balls.length);
                        prev_1 = (index - 1 >= 0) ? index - 1 : balls.length - 1;

                        balls[next_1].classList.add(c6);
                        balls[next_2].classList.add(c7);
                        balls[next_3].classList.add(c8);
                        balls[prev_1].classList.add(c9);
                    });
                }, // slider_historic

                load_templates_api: async () => {
                    await Promise.all([
                        loadHTML(url_template),
                        loadJSON(url_json_historic)
                    ])
                        .then(([templates, data_historic]) => {
                            s0.insertAdjacentHTML("afterend", templates);
                            NSHistoric.data_historic = data_historic;
                            check_load[1] = true;
                        })
                        .catch(err => console.error(err))
                    ;
                } // load_templates_api
            };
        }())
    ;

    window.addEventListener("load", async function () {
        await NSHistoric.load_templates_api();
        NSHistoric.slider_historic();
        check_load[0] = true;
    });
}());
