/* global SimpleSlider, check_load  */

(function () {
    "use strict";

    check_load[0] = false;
    check_load[1] = false;

    let
        did_desktop = false,
        did_mobile  = false
    ;

    const
        // URLS
        url_template = "../templates/templates.html",

        // Selectors
        s0 = document.body,
        // s1
        // s2
        s3 = document.getElementById("slider_showcase"),
        // s7
        // s8
        // s9
        // s10
        // s11
        // s12
        // s13
        // s14
        // s15
        s16 = document.getElementById("img_visor_showcase"),
        s17 = document.getElementById("container_ball"),
        s18 = document.getElementById("bg_visor_showcase"),
        // s19

        // tooltips
        s4 = document.getElementById("container_tooltip_1"),
        s5 = document.getElementById("container_tooltip_2"),
        s6 = document.getElementById("container_tooltip_3"),

        // Class
        c1 = "active",
        // c2
        c3 = "open",
        c4 = "close",
        c5 = "hide",
        // c6
        // c7
        // c8
        // c9
        c10 = "mobile",

        tooltips = [ s4, s5, s6 ],

        matchQuery = window.matchMedia("(min-width: 769px)"),

        NSHome = (function () {
            function loadHTML(url) {
                return fetch(url).then(response => response.text());
            }

            return {
                initial_tooltip: () => {
                    for (const item of tooltips) {
                        let cent = true;

                        const
                            btn_open = item.querySelector(".open_tooltip"),
                            btn_close = item.querySelector(".close_tooltip"),
                            tooltip = item.querySelector(".tooltip")
                        ;

                        btn_open.addEventListener("click", function () {
                            this.parentElement.classList.add(c1);

                            if (cent) {
                                if (tooltip.classList.contains(c3)) {
                                    tooltip.classList.remove(c3);
                                    tooltip.classList.add(c4);
                                    this.parentElement.classList.remove(c1);
                                } else {
                                    tooltip.classList.add(c3);
                                    tooltip.classList.remove(c4);
                                }

                                this.classList.toggle(c1);

                                setTimeout(() => { cent = true; }, 1000);
                                cent = false;
                            }
                        });

                        btn_close.addEventListener("click", function () {
                            this.parentElement.parentElement.classList.remove(c1);
                            if (cent) {
                                tooltip.classList.remove(c3);
                                tooltip.classList.add(c4);
                                btn_open.classList.remove(c1);

                                setTimeout(() => { cent = true; }, 1000);
                                cent = false;
                            }
                        });
                    }
                },

                scroll_ball_mobile: () => {
                    const
                        ball = document.getElementById("main_ball")
                    ;

                    if (ball) ball.classList.add(c10);
                    s16.classList.add(c10);

                    s18.appendChild(s17);

                    for (const item of s17.children) {
                        item.classList.remove(c5);
                    }
                }, // scroll_ball_mobile

                slider_showcase: () => {
                    const
                        showcase_slider = new SimpleSlider(s3, {
                            classSlider: "slider_showcase",
                            linkIndicator: true
                        })
                    ;

                    showcase_slider.init();
                }, // slider_showcase

                evaluate_match_query: () => {
                    if (matchQuery.matches) {
                        if (!did_desktop) {
                            did_desktop = true;
                            did_mobile = false;
                        }
                    } else {
                        if (!did_mobile) {
                            did_desktop = false;
                            did_mobile = true;
                        }
                    }
                }, // evaluate_match_query

                load_templates_api: async () => {
                    await Promise.all([
                        loadHTML(url_template),
                    ])
                        .then(([templates]) => {
                            s0.insertAdjacentHTML("afterend", templates);
                            check_load[1] = true;
                        })
                        .catch(err => console.error(err))
                    ;
                } // load_templates_api
            };
        }())
    ;

    if ("scrollRestoration" in history) history.scrollRestoration = "manual";

    window.addEventListener("load", async function () {
        await NSHome.load_templates_api();
        NSHome.evaluate_match_query();
        NSHome.initial_tooltip();
        NSHome.slider_showcase();

        if (matchQuery.addEventListener) matchQuery.addEventListener("change", NSHome.evaluate_match_query);
        else matchQuery.addListener(NSHome.evaluate_match_query);

        NSHome.scroll_ball_mobile();
        check_load[0] = true;
    });

    function is_mobile() {
        return /Mobi|Android|iPhone|iPad|iPod/i.test(navigator.userAgent);
    }

    window.addEventListener("resize", () => {
        if (!is_mobile()) window.location.reload();
    });
}());
