/* global check_load, Swiper */

(function () {
    "use strict";

    console.log("pro_jersey.js loaded");
    check_load[0] = false;

    let current_index_fed = 0;

    const
        // ULRs
        url_template = "../templates/templates.html",
        url_main_json = "../assets/json/main.json",
        url_json_pro_jersey = "../assets/json/pro_jersey.json",

        // Selectors
        s0 = document.body,
        s3 = document.getElementById("container_cards"),
        // Class
        c1 = "active",
        c5 = "hide",
        c6_j = "fed_",

        // Variables
        current_page = "jersey",
        current_module = "pro_jersey",

        NSJersey = (function () {
            function loadHTML(url) {
                return fetch(url).then(response => response.text());
            }

            function loadJSON(url) {
                return fetch(url).then(response => response.json());
            }

            function change_body_federation(index) {
                if (NSJersey.now_federation === null) return;

                for (let i = 0; i < NSJersey.data_main.federations.length; i++) {
                    s0.classList.remove(c6_j + i);
                }

                if (index !== 0) s0.classList.add(c6_j + index);
            } // change_body_federation

            function setup_federation_navigation() {
                const
                    b1 = document.querySelector(".btn_fed_prev"),
                    b2 = document.querySelector(".btn_fed_next");

                if (!b1 || !b2) return;

                const federations = (NSJersey.data_main && NSJersey.data_main.federations) ? NSJersey.data_main.federations : [];

                if (federations.length === 1) {
                    b1.classList.add(c5);
                    b2.classList.add(c5);
                    return;
                }

                b1.classList.remove(c5);
                b2.classList.remove(c5);

                b1.addEventListener("click", function () {
                    if (!NSJersey.data_main || !NSJersey.data_main.federations) return;

                    current_index_fed--;
                    if (current_index_fed < 0) {
                        current_index_fed = NSJersey.data_main.federations.length - 1;
                    }

                    NSJersey.change_info(current_index_fed);
                });

                b2.addEventListener("click", function () {
                    if (!NSJersey.data_main || !NSJersey.data_main.federations) return;

                    current_index_fed++;
                    if (current_index_fed >= NSJersey.data_main.federations.length) {
                        current_index_fed = 0;
                    }

                    NSJersey.change_info(current_index_fed);
                });
            }

            return {
                data_main: {},
                data_pro_jersey: [],
                now_federation: null,
                prev_federation: null,

                change_info: (index) => {
                    const nextFederation = NSJersey.data_main.federations[index];
                    if (!nextFederation || nextFederation === NSJersey.now_federation) return;

                    NSJersey.prev_federation = NSJersey.now_federation;
                    NSJersey.now_federation = nextFederation;

                    change_body_federation(index);

                    const reorderedItems = NSJersey.sort_pro_jersey_items();

                    if (s3) {
                        s3.innerHTML = "";
                        NSJersey.load_items_slider_jersey(reorderedItems);
                    }

                    if (NSJersey.pro_swiper) {
                        NSJersey.pro_swiper.updateSlides();
                        NSJersey.pro_swiper.updateProgress();
                        NSJersey.pro_swiper.updateSlidesClasses();
                        NSJersey.pro_swiper.slideTo(0, 0);
                        NSJersey.pro_swiper.update();
                    }
                }, // change_info

                load_items_slider_jersey: (items = NSJersey.data_pro_jersey) => {
                    if (!s3 || !Array.isArray(items) || items.length === 0) {
                        return;
                    }

                    const template = document.getElementById("template_swiper_slide_jersey");
                    if (!template) return;

                    for (const data of items) {
                        const
                            pro_jersey = template.content.cloneNode(true),
                            card = pro_jersey.querySelector(".card"),
                            img = pro_jersey.querySelector(".img_product"),
                            img_back = pro_jersey.querySelector(".img_technical"),
                            name = pro_jersey.querySelector(".name_product"),
                            title_back_1 = pro_jersey.querySelector(".title_back_1"),
                            title_back_2 = pro_jersey.querySelector(".title_back_2"),
                            price = pro_jersey.querySelector(".price_product"),
                            link = pro_jersey.querySelector(".btn_buy"),
                            btn_flip_card = pro_jersey.querySelector(".btn_flip_card"),
                            btn_close_flip_card = pro_jersey.querySelector(".btn_close_flip_card")
                        ;

                        img.src = data.img;
                        img.alt = data.name;

                        name.textContent = data.name;
                        price.textContent = data.price;

                        title_back_1.textContent = data.title_back_1;
                        title_back_2.textContent = data.title_back_2;
                        img_back.src = data.img_back;
                        img_back.alt = data.title_back_1 + " " + data.title_back_2;

                        link.href = data.url || "#";
                        link.target = data.target || "_top";

                        btn_flip_card.addEventListener("click", function () {
                            card.classList.add(c1);
                        });

                        btn_close_flip_card.addEventListener("click", function () {
                            card.classList.remove(c1);
                        });

                        if (card) {
                            card.dataset.country = (data.country || "").toString().trim().toLowerCase();
                        }

                        s3.appendChild(pro_jersey);
                        console.log("aja chico cree una tarjeta");
                    }
                }, // load_items_slider_jersey

                sort_pro_jersey_items: () => {
                    const items = Array.isArray(NSJersey.data_pro_jersey)
                        ? NSJersey.data_pro_jersey.slice()
                        : [];

                    if (!NSJersey.now_federation || items.length === 0) return items;

                    const normalize = value => (value || "").toString().trim().toLowerCase();
                    const targetCountry = normalize(NSJersey.now_federation.country);
                    if (!targetCountry) return items;

                    const matching = items.filter(item => normalize(item.country) === targetCountry);
                    const remaining = items.filter(item => normalize(item.country) !== targetCountry);

                    return matching.concat(remaining);
                }, // sort_pro_jersey_items

                pro_jersey: () => {
                    const initialItems = NSJersey.sort_pro_jersey_items(NSJersey.now_federation);
                    if (initialItems.length > 0) {
                        NSJersey.load_items_slider_jersey(initialItems);
                    }

                    NSJersey.pro_swiper = new Swiper(".swiper", {
                        slidesPerView: 1,
                        spaceBetween: 0,
                        freeMode: true,
                        breakpoints: {
                            320: {
                                slidesPerView: 1,
                                spaceBetween: 15,
                            },
                            480: {
                                slidesPerView: 1.5,
                                spaceBetween: 30,
                            },
                            768: {
                                slidesPerView: 2,
                                spaceBetween: 25,
                            },
                            980: {
                                slidesPerView: 3,
                                spaceBetween: 20,
                            },
                            1280: {
                                slidesPerView: 4,
                                spaceBetween: 20,
                            },
                            1440: {
                                slidesPerView: 5,
                                spaceBetween: 15,
                            }
                        },
                        scrollbar: {
                            el: ".swiper-scrollbar",
                            hide: false,
                            draggable: true,
                            snapOnRelease: false,
                        }
                    });

                    NSJersey.pro_swiper.update();
                }, // pro_jersey

                load_templates_api: async () => {
                    await Promise.all([
                        loadHTML(url_template),
                        loadJSON(url_json_pro_jersey),
                        loadJSON(url_main_json)
                    ])
                        .then(([
                            templates,
                            data_pro_jersey,
                            data_main
                        ]) => {
                            const container = document.createElement("div");
                            container.innerHTML = templates;

                            const filteredTemplates = Array
                                .from(container.querySelectorAll("template"))
                                .filter(templateEl => {
                                    const pageTarget = templateEl.dataset.page || "both";

                                    const moduleTarget = templateEl.dataset.module || "";

                                    return pageTarget === "both" || pageTarget === current_page && moduleTarget === current_module;
                                })
                                .map(templateEl => templateEl.outerHTML)
                                .join("")
                            ;

                            if (filteredTemplates) {
                                s0.insertAdjacentHTML("afterend", filteredTemplates);
                            }

                            NSJersey.data_pro_jersey = data_pro_jersey;
                            NSJersey.data_main = data_main;

                            // Inicializar federaciones
                            if (NSJersey.data_main.length !== 0 && NSJersey.data_main.federations.length !== 0) {
                                NSJersey.now_federation = data_main.federations[0];
                                NSJersey.change_info(0);
                                setup_federation_navigation();
                            }

                            check_load[1] = true;
                        })
                        .catch(err => console.error(err))
                    ;
                } // load_templates_api
            };
        }())
    ;

    window.addEventListener("load", async function () {
        await NSJersey.load_templates_api();
        NSJersey.pro_jersey();
        check_load[0] = true;
    });
}());